/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWString;
import filenet.vw.base.expr.VWParser;
import filenet.vw.server.VWFieldUtility;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;

public final class VWFieldType {
    public static final int FIELD_TYPE_INT = 1;
    public static final int FIELD_TYPE_STRING = 2;
    public static final int FIELD_TYPE_BOOLEAN = 4;
    public static final int FIELD_TYPE_FLOAT = 8;
    public static final int FIELD_TYPE_TIME = 16;
    public static final int FIELD_TYPE_ATTACHMENT = 32;
    public static final int FIELD_TYPE_PARTICIPANT = 64;
    public static final int FIELD_TYPE_XML = 128;
    public static final int FIELD_TYPEDEF_TIME32 = 16;
    public static final int FIELD_TYPEDEF_TIME64 = 256;
    public static final int FIELD_TYPE_GUID = 512;
    public static final int BASIC_FIELD_TYPES = 31;
    public static final int ALL_FIELD_TYPES = 767;
    public static final String TIME_MASK = "MM/dd/yyyy HH:mm:ss";
    protected static final String TIME_MASK_CANONICAL = "mm/dd/yyyy hh:tt:ss";
    public static final int MAX_IDENTIFIER_LENGTH = 128;
    private static String[] LocalizedStrings = new String[]{new VWString("vw.api.VWFieldTypeInteger", "Integer").toString(), new VWString("vw.api.VWFieldTypeString", "String").toString(), new VWString("vw.api.VWFieldTypeBoolean", "Boolean").toString(), new VWString("vw.api.VWFieldTypeFloat", "Float").toString(), new VWString("vw.api.VWFieldTypeTime", "Time").toString(), new VWString("vw.api.VWFieldTypeAttachment", "Attachment").toString(), new VWString("vw.api.VWFieldTypeParticipant", "Participant").toString(), new VWString("vw.api.VWFieldTypeXML", "XML").toString(), new VWString("vw.api.VWFieldTypeTime64", "Time64").toString(), new VWString("vw.api.VWFieldTypeGuid", "Guid").toString()};
    private static String[] m_localizedTypeDefStrings = new String[]{new VWString("vw.api.VWFieldTypeDefTime32", "Time32 (deprecated)").toString(), new VWString("vw.api.VWFieldTypeDefTime64", "Time").toString()};

    public static String _get_FILE_DATE() {
        return "$Date: 2010-11-12 00:43:28 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/PUI_460_FP01_Int/1 $";
    }

    public static String getLocalizedString(int theFieldType) throws VWException {
        if (!VWFieldType.isValid(theFieldType)) {
            throw new VWException("vw.api.VWFieldTypeBadInteger", "Integer form of the field type is invalid: {0}", String.valueOf(theFieldType));
        }
        return LocalizedStrings[VWFieldType.twoPower(theFieldType)];
    }

    private static int twoPower(int theFieldType) {
        int fType = theFieldType;
        int exponent = 0;
        while ((fType >>= 1) != 0) {
            ++exponent;
        }
        return exponent;
    }

    public static String getLocalizedDefinitionString(int theFieldDefinitionType) throws VWException {
        if (!VWFieldType.isValid(theFieldDefinitionType)) {
            throw new VWException("vw.api.VWFieldTypeBadInteger2", "Integer form of the field definition type is invalid: {0}", String.valueOf(theFieldDefinitionType));
        }
        switch (theFieldDefinitionType) {
            case 16: {
                return m_localizedTypeDefStrings[0];
            }
            case 256: {
                return m_localizedTypeDefStrings[1];
            }
        }
        return VWFieldType.getLocalizedString(theFieldDefinitionType);
    }

    public static boolean isValidName(String theName) {
        return VWFieldType.isValidName(theName, true);
    }

    protected static boolean isValidParamName(String theName) {
        return theName != null && (theName.length() <= 1 || !theName.startsWith("F_")) && VWFieldType.isIdentifier(theName);
    }

    protected static boolean isValidWebServiceParamName(String theName) {
        if (theName == null) {
            return false;
        }
        if (theName.indexOf(32) != -1) {
            return false;
        }
        if (theName.indexOf(9) != -1) {
            return false;
        }
        return theName.indexOf(58) == -1;
    }

    protected static boolean isKeyWord(String theWord) {
        return theWord.equals("abs") || theWord.equals("adddays") || theWord.equals("addhours") || theWord.equals("addminutes") || theWord.equals("addmonths") || theWord.equals("addseconds") || theWord.equals("addyears") || theWord.equals("alt_field_defined") || theWord.equals("and") || theWord.equals("bitand") || theWord.equals("bitnot") || theWord.equals("bitor") || theWord.equals("blue") || theWord.equals("boolean") || theWord.equals("color") || theWord.equals("convert") || theWord.equals("currency") || theWord.equals("datetostring") || theWord.equals("date") || theWord.equals("days_between") || theWord.equals("document") || theWord.equals("envfield") || theWord.equals("float") || theWord.equals("err_encode") || theWord.equals("false") || theWord.equals("field_defined") || theWord.equals("folder") || theWord.equals("green") || theWord.equals("hex") || theWord.equals("if") || theWord.equals("in_set") || theWord.equals("int") || theWord.equals("is_date") || theWord.equals("is_null") || theWord.equals("is_number") || theWord.equals("is_time") || theWord.equals("is_valid") || theWord.equals("len") || theWord.equals("integer") || theWord.equals("lower") || theWord.equals("ltrim") || theWord.equals("max") || theWord.equals("min") || theWord.equals("mod") || theWord.equals("not") || theWord.equals("null") || theWord.equals("numbertostring") || theWord.equals("number") || theWord.equals("or") || theWord.equals("random") || theWord.equals("red") || theWord.equals("repeat") || theWord.equals("rtrim") || theWord.equals("seconds_between") || theWord.equals("selection") || theWord.equals("sizeof") || theWord.equals("stringtodate") || theWord.equals("stringtotime") || theWord.equals("string") || theWord.equals("strins") || theWord.equals("strloc") || theWord.equals("substitute") || theWord.equals("substr") || theWord.equals("systemdate") || theWord.equals("systemenvfield") || theWord.equals("systemtime") || theWord.equals("timetostring") || theWord.equals("time") || theWord.equals("translate") || theWord.equals("trim") || theWord.equals("true") || theWord.equals("unsigned") || theWord.equals("upper") || theWord.equals("userenvfield") || theWord.equals("userid") || theWord.equals("weekday") || theWord.equals("dist_bernoulli") || theWord.equals("dist_beta") || theWord.equals("dist_binomial") || theWord.equals("dist_exponential") || theWord.equals("dist_gamma") || theWord.equals("dist_geometric") || theWord.equals("dist_lognormal") || theWord.equals("dist_normal") || theWord.equals("dist_poisson") || theWord.equals("dist_uniform") || theWord.equals("dist_weibull") || theWord.equals("xmlinsertbefore") || theWord.equals("xmlinsertafter") || theWord.equals("xmlinsertchildfirst") || theWord.equals("xmlinsertchildlast") || theWord.equals("xmlremove") || theWord.equals("xmlrename") || theWord.equals("xmlbooleanexpr") || theWord.equals("xmlintegerexpr") || theWord.equals("xmlfloatexpr") || theWord.equals("xmlstringexpr") || theWord.equals("xmlstringarrayexpr") || theWord.equals("xmltransform") || theWord.equals("is_wellformed") || theWord.equals("is_validxml") || theWord.equals("elementcount") || theWord.equals("nextelement") || theWord.equals("attachment") || theWord.equals("arraytostring") || theWord.equals("encode") || theWord.equals("decode") || theWord.equals("xmlencode") || theWord.equals("xmldecode");
    }

    protected static boolean isIdentifier(String theWord) {
        if (theWord == null || theWord.length() == 0) {
            return false;
        }
        if (theWord.length() < 1 || theWord.length() > 128) {
            return false;
        }
        if (!Character.isLetter(theWord.charAt(0))) {
            return false;
        }
        for (int i = 1; i < theWord.length(); ++i) {
            char c = theWord.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || Character.getType(c) == 6) continue;
            return false;
        }
        return true;
    }

    protected static boolean isValidName(String theName, boolean rejectF_Names) {
        if (!VWFieldType.isIdentifier(theName)) {
            return false;
        }
        if (rejectF_Names && theName.length() > 1 && theName.startsWith("F_")) {
            return false;
        }
        return !VWFieldType.isKeyWord(theName);
    }

    public static boolean isValid(int fieldType) {
        return fieldType == 1 || fieldType == 2 || fieldType == 4 || fieldType == 8 || fieldType == 16 || fieldType == 32 || fieldType == 64 || fieldType == 128 || fieldType == 256 || fieldType == 512;
    }

    public static boolean isValid(Object theValue) {
        return VWFieldType.isValid(VWFieldType.getVWFieldType(theValue));
    }

    public static int getVWFieldType(Object theValue) {
        if (theValue == null) {
            return -1;
        }
        if (theValue instanceof Integer || theValue instanceof Integer[]) {
            return 1;
        }
        if (theValue instanceof String || theValue instanceof String[]) {
            return 2;
        }
        if (theValue instanceof Boolean || theValue instanceof Boolean[]) {
            return 4;
        }
        if (theValue instanceof Double || theValue instanceof Double[]) {
            return 8;
        }
        if (theValue instanceof Date || theValue instanceof Date[]) {
            return 16;
        }
        if (theValue instanceof VWAttachment || theValue instanceof VWAttachment[]) {
            return 32;
        }
        if (theValue instanceof VWParticipant || theValue instanceof VWParticipant[]) {
            return 64;
        }
        if (theValue instanceof VWXMLData || theValue instanceof VWXMLData[]) {
            return 128;
        }
        if (theValue instanceof VWGuid || theValue instanceof VWGuid[]) {
            return 512;
        }
        if (theValue instanceof Object[]) {
            return VWFieldType.getVWFieldType(((Object[])theValue)[0]);
        }
        return -1;
    }

    public static Object stringToValue(String theString, int theType, boolean isArray) throws VWException {
        Object retVal = null;
        if (!VWFieldType.isValid(theType)) {
            throw new VWException("vw.api.VWFieldTypeInvalidType", "The type passed is {0}, which is not a valid type.", String.valueOf(theType));
        }
        if (theString == null || theString.length() <= 0) {
            return null;
        }
        theString = theString.trim();
        try {
            retVal = VWFieldUtility.makeObjectFromString(theString, theType, isArray);
        }
        catch (NumberFormatException e) {
            throw new VWException("vw.api.VWNumberFormatError", "The string can not be converted to field type {0}: {1}.", VWFieldType.getLocalizedString(theType), theString);
        }
        catch (ParseException ex) {
            throw new VWException("vw.api.VWDateFormatParse", "Date format error: {0} at {1}: {2}.", ex.getMessage(), ex.getErrorOffset(), theString);
        }
        return retVal;
    }

    public static String typeToString(int fieldType) throws VWException {
        switch (fieldType) {
            case 1: {
                return "int";
            }
            case 2: {
                return "string";
            }
            case 4: {
                return "boolean";
            }
            case 8: {
                return "float";
            }
            case 16: {
                return "time";
            }
            case 32: {
                return "attachment";
            }
            case 64: {
                return "participant";
            }
            case 128: {
                return "xml";
            }
            case 256: {
                return "time64";
            }
            case 512: {
                return "ceobject";
            }
            case -1: {
                return "unknown";
            }
        }
        throw new VWException("vw.api.VWFieldTypeBadInteger", "Integer form of the field type is invalid: {0}", String.valueOf(fieldType));
    }

    public static int stringToType(String fieldType) throws VWException {
        if (fieldType == null) {
            throw new VWException("vw.api.VWFieldTypeBadStringNull", "field type is invalid, null");
        }
        if (fieldType.equals("int")) {
            return 1;
        }
        if (fieldType.equals("string") || fieldType.equals("")) {
            return 2;
        }
        if (fieldType.equals("boolean")) {
            return 4;
        }
        if (fieldType.equals("float")) {
            return 8;
        }
        if (fieldType.equals("time")) {
            return 16;
        }
        if (fieldType.equals("attachment")) {
            return 32;
        }
        if (fieldType.equals("participant")) {
            return 64;
        }
        if (fieldType.equals("xml")) {
            return 128;
        }
        if (fieldType.equals("time64")) {
            return 256;
        }
        if (fieldType.equals("ceobject")) {
            return 512;
        }
        throw new VWException("vw.api.VWFieldTypeBadString", "String form of the field type is invalid: {0}", fieldType);
    }

    public static int lValue(String theExpr, VWWorkflowSignature theSig, VWWorkflowDefinition theWF) throws VWException {
        if (theWF == null && theSig == null) {
            throw new VWException("vw.api.VWFieldTypeLValueNoSigOrWF", "invalid lValue call, both theSig and theWF parameters are null");
        }
        if (theWF == null && theSig != null) {
            return 0;
        }
        if (theWF != null) {
            String fldName;
            String tmpS = theExpr.trim();
            StringTokenizer strTk = new StringTokenizer(tmpS, "[] \t\n\r", true);
            if (strTk.hasMoreTokens() && (fldName = strTk.nextToken()) != null) {
                VWFieldDefinition foundField = null;
                if (theWF.isExistingFieldName(fldName)) {
                    foundField = theWF.getField(fldName);
                } else if (theSig != null) {
                    foundField = theSig.findField(fldName);
                }
                if (foundField != null) {
                    if (!foundField.isArray) {
                        if (strTk.hasMoreTokens()) {
                            return 0;
                        }
                    } else {
                        if (!strTk.hasMoreTokens()) {
                            return -foundField.getFieldType();
                        }
                        String[] theErrorStrings = VWParser.parseVWExpr(theExpr, theWF, foundField.getFieldType(), false, true);
                        if (theErrorStrings != null && theErrorStrings.length > 0) {
                            return 0;
                        }
                        if (!tmpS.endsWith("]")) {
                            return 0;
                        }
                        int ssExprBeginIdx = tmpS.indexOf(91) + 1;
                        int ssExprEndIdx = tmpS.lastIndexOf(93);
                        if (ssExprBeginIdx == 0) {
                            return 0;
                        }
                        String subScriptExpr = tmpS.substring(ssExprBeginIdx, ssExprEndIdx);
                        if (subScriptExpr.length() == 0) {
                            return 0;
                        }
                        theErrorStrings = null;
                        theErrorStrings = VWParser.parseVWExpr(subScriptExpr, theWF, 1, false, true);
                        if (theErrorStrings != null && theErrorStrings.length > 0) {
                            return 0;
                        }
                    }
                    return foundField.getFieldType();
                }
            }
            return 0;
        }
        return 0;
    }

    protected static boolean isCompatibleType(int leftType, int rightType) throws VWException {
        if (!VWFieldType.isValid(leftType) || !VWFieldType.isValid(rightType)) {
            return false;
        }
        boolean isCompat = false;
        switch (leftType) {
            case 1: 
            case 8: {
                if (rightType != 1 && rightType != 8) break;
                isCompat = true;
                break;
            }
            case 4: {
                if (rightType != 4) break;
                isCompat = true;
                break;
            }
            case 2: 
            case 32: 
            case 64: 
            case 128: 
            case 512: {
                if (rightType != 2 && rightType != 32 && rightType != 64 && rightType != 128 && rightType != 512) break;
                isCompat = true;
                break;
            }
            case 16: {
                if (rightType != 16 && rightType != 2) break;
                isCompat = true;
                break;
            }
            case 256: {
                if (rightType != 16 && rightType != 256 && rightType != 2) break;
                isCompat = true;
            }
        }
        return isCompat;
    }
}

